(function () {
    if (input) {
        if (input.action == 'saveactivityhistory') {

            try {
                var phoneLogRecord = new GlideRecord('sn_openframe_phone_log');
                phoneLogRecord.initialize();

                phoneLogRecord.setValue('call_id', input.data.globalInteractionId);
                phoneLogRecord.setValue('call_type', input.data.direction);
                phoneLogRecord.setValue('start_time', input.data.startTime);
                phoneLogRecord.setValue('end_time', input.data.endTime);
                var duration = new GlideDuration(Number(input.data.duration));
                phoneLogRecord.setValue('duration', duration);
                phoneLogRecord.setValue('phone_number', "+" + input.data.phonenumber);
                phoneLogRecord.setValue('x_bripa_occsn_disposition', input.data.disposition);
                phoneLogRecord.setValue('x_bripa_occsn_notes', input.data.description);
                phoneLogRecord.setValue('x_bripa_occsn_service', input.data.service);
                phoneLogRecord.setValue('x_bripa_occsn_recording_url', input.data.playbackUrl);
                phoneLogRecord.setValue('x_bripa_occsn_global_id', input.data.globalInteractionId);
                phoneLogRecord.setValue('x_bripa_occsn_destination_number', "+" + input.data.dnis);
                phoneLogRecord.setValue('x_bripa_occsn_qm_url', input.data.recordingUrl);
				phoneLogRecord.setValue('recording_url',
                    'Interaction type: ' + input.data.type + '\n' +
                    'Recording URL: ' + input.data.recordingUrl + '\n' +
                    'Service: ' + input.data.service + '\n' +
                    'Disposition: ' + input.data.disposition + '\n' +
                    'Notes: ' + input.data.description + '\n' +
                    'Phone: ' + input.data.phonenumber + '\n'
                );

                var taskId = input.taskId || input.data['sn:task'];
                if (taskId) {
                    phoneLogRecord.setValue('task', taskId);
                }

                var contactId = input.contactId || input.data['sn:contact'];
                if (contactId) {
                    phoneLogRecord.setValue('contact', contactId);
                } else {
                    try {
                        var contactRecord = new GlideRecord('sys_user');
                        contactRecord.initialize();
                        var phoneNumber = '+' + input.data.phonenumber;
                        var foundRecord = contactRecord.get('phone', phoneNumber);
                        if (foundRecord) {
                            contactId = contactRecord.getUniqueValue();
                            phoneLogRecord.setValue('contact', contactId);
                        }
                    } catch (e) { }
                }

                var insertResult = phoneLogRecord.insert();
                data.result = {
                    success: true,
                    insertedValue: insertResult
                };

            } catch (e) {
                data.result = {
                    success: false,
                    error: e
                };
            }
        }
    }
})();
